SELECT fab.first_aid_box_place as posto,
       fab.first_aid_box_name as nome_box,
       fabd.first_aid_box_detail_name as dettagli,
       fabd.first_aid_box_detail_quantity as quantita,
       fabd.edate_at as scadenza
from first_aid_box_details as fabd
         left join first_aid_boxes as fab on fabd.first_aid_box_id = fab.first_aid_box_id
WHERE fabd.edate_at <> 'NULL'
  AND fabd.edate_at
    BETWEEN NOW() and DATE_ADD(NOW(), INTERVAL 60 DAY)

order by fabd.edate_at, fab.first_aid_box_place, fab.first_aid_box_name, fabd.first_aid_box_detail_name,
         fabd.first_aid_box_detail_quantity asc